const { sendErrorResponse, sendResponse, } = require("../../utils/index.js");
const { tables } = require("../../utils/tables.js");
const { performQuery } = require("../../utils/db.js");
const moment = require("moment-timezone");
const { getTimezone, getSystemTime } = require("../../functions/getTimezone.js");
const fs = require('fs');
const path = require('path');

// READ User Attendance
module.exports.getAttendanceData = async (req, res) => {
  try {
    const { id } = req.query;

    let query = `
    SELECT 
      data.*, emp.employee_id_external, person.first_name, person.mid_name, person.last_name, person.display_name
    FROM ${tables.attendance_data} data
    Left Join ${tables.attendance_user} user ON data.employee_id = user.id
    LEFT JOIN ${tables.emp_employee} emp ON user.employee_id_external = emp.employee_id_external
    LEFT JOIN ${tables.per_person} person ON emp.person_id_external = person.person_id_external
    WHERE emp.employee_id_external IS NOT NULL`;
 
    if (id) query += ` AND id = ${id}`;
    query += ` ORDER BY id DESC`;
    
    const result = await performQuery(query);
    
    return sendResponse(res, result, "Attendance Data fetched successfully", 200);

  } catch (error) {
    console.error("Error While Fetching Attendance Data:", error);
    return sendErrorResponse(res, error, "Error while fetching Data:");
  }
};

module.exports.updateAttendanceData = async (req, res) => {
  try {
    const {
        id, 	
        clock_in,		
        clock_out,
        isLate = 0,		
        isEarly = 0,		
        isWFH = 0,		
        comments_for_Absent,		
        comments_for_miss_punchin_or_out,
    } = req.body;

    // Required Validation
    if (!id) {
      const errorMessage = "Missing required fields";
      return sendErrorResponse(res, errorMessage, errorMessage);
    }
        
    // Check Record Exists 
    const existing = await performQuery(
      `SELECT * FROM ${tables.attendance_data} WHERE id = ?`,
      [id]
    );

    if (!existing || existing.length === 0) {
      const errorMessage = "Attendance record not found";
      return sendErrorResponse(res, errorMessage, errorMessage);
    }

    const oldRecord = existing[0];

    // System Time
    const systemTime = await getSystemTime();
    const currentTime = moment(systemTime).format("YYYY-MM-DD HH:mm:ss");

    // calculate duty hours: difference between clock_in and clock_out in hours
    let calculatedDutyHours = (clock_in || clock_out) ? moment(clock_out).diff(moment(clock_in), 'hours'):0;

    // Prepare update object
    const updatedData = {
      clock_in : clock_in || oldRecord.clock_in,
      clock_out: clock_out || oldRecord.clock_out,
      isLate : isLate || oldRecord.isLate,
      isEarly : isEarly || oldRecord.isEarly,
      isWFH : isWFH || oldRecord.isWFH,
      duty_hours: calculatedDutyHours || oldRecord.duty_hours,
      comments_for_Absent : comments_for_Absent || oldRecord.comments_for_Absent,
      comments_for_miss_punchin_or_out : comments_for_miss_punchin_or_out || oldRecord.comments_for_miss_punchin_or_out

    };

    // Update query
    await performQuery(`UPDATE ${tables.attendance_data} SET ? WHERE id = ?`, [
      updatedData,
      id,
    ]);

    return sendResponse(res, {}, "Attendance Data updated successfully", 200);
  } catch (error) {
    console.error("Error While Updating Attendance Data: ", error);
    return sendErrorResponse(res, error, "Error while updating Attendance Data");
  }
};
