const moment = require("moment"); // Import required libraries
const { getSystemTime, getTimezone } = require("../functions/serverTime");
const { tables } = require("../utils/tables");
const { performQuery } = require("../utils/dbFunctions");

const getShiftTimes = async (shift, timestamp) => {
  // const currentDate = moment(await getSystemTime()).add(40,"minutes"); // Get today's date using moment
  const currentDate = moment(timestamp); // Get today's date using moment
  const timezone = await getTimezone(); // Replace with your desired timezone

  
  
  // Parse the start and end times
  let startDateTime = moment.tz(
    `${currentDate.format("YYYY-MM-DD")} ${shift.shiftStart}`,
    timezone
  );
  let endDateTime = moment.tz(
    `${currentDate.format("YYYY-MM-DD")} ${shift.shiftEnd}`,
    timezone
  );
  
  
  // If the end time is earlier than the start time, add 1 day to the endDateTime
  if (endDateTime.isSameOrBefore(startDateTime)) {
    if(currentDate < endDateTime){
      startDateTime.subtract(1, "day");
    }
    else{
      endDateTime.add(1, "day");
    }
  }

  

  // Format the dates into "MM/DD/YYYY HH:mm:ss"
  const formattedStart = startDateTime.format("MM/DD/YYYY HH:mm:ss");
  const formattedEnd = endDateTime.format("MM/DD/YYYY HH:mm:ss");

  return {
    shift_name: shift.shiftName,
    start: formattedStart,
    end: formattedEnd,
  };
};

const getShiftData = async (timestamp) => {
  try {
    
    const currentTime = moment(timestamp).format("HH:mm:ss");
    const getShiftQuery = `
      SELECT * 
      FROM ${tables.shift}
      WHERE
        isActive = 1 AND  
        (
          (
            -- For shifts that do NOT span midnight
            TIME(shiftStart) <= TIME(?) 
            AND TIME(shiftEnd) > TIME(?)
            AND shiftEnd > shiftStart
          ) 
          OR (
            -- For shifts that span midnight
            TIME(shiftStart) > TIME(shiftEnd)
            AND (
                TIME(?) >= TIME(shiftStart) 
                OR TIME(?) < TIME(shiftEnd)
            )
          )
        )
    `;

    const shiftData = await performQuery(getShiftQuery, [currentTime, currentTime, currentTime, currentTime]);
    
    return shiftData;
  } catch (error) {
    console.error("Error in getShiftData: ", error);
    throw error;
  }
};

module.exports = {
  getShiftTimes, getShiftData
};




