const router = require("express").Router();

const authRoute = require("./auth.route");
const picklistRoute = require("./picklist.route");
const personRoutes = require("./person.route");
const organizationRoutes = require("./organization.route");
const employeeRoutes = require("./employeeRecords.route");
const { authMiddleware } = require("../middleware/authMiddleware");
const attendanceRoutes = require("./attendanceRecord.route");

//===> Auth
router.use("/auth", authRoute);

//===> Person Record
router.use("/personRecord", authMiddleware, personRoutes);

//===> Picklist
router.use("/picklist", authMiddleware, picklistRoute);

//===> Organization Record
router.use("/organizationRecord", authMiddleware, organizationRoutes);

// ===> Employee Record
router.use("/employeeRecord", authMiddleware, employeeRoutes);

// ===> Attendance Record
router.use("/attendance-record", authMiddleware, attendanceRoutes);

module.exports = router;
