const {
  sendErrorResponse,
  sendResponse,
} = require("../../utils/index.js");
const { tables } = require("../../utils/tables.js");
const { performQuery } = require("../../utils/db.js");
const moment = require("moment-timezone");
const { getTimezone, getSystemTime } = require("../../functions/getTimezone.js");
const { error } = require("winston");

// Create Employee-Details
module.exports.createEmployeeDetails = async (req, res) => {
  try{
    const { 
      employee_id_external,
      start_date,
      seq_no,
      event_reason,
      position_id,
      manager_id,
      custom_string_3,
      time_event_type_group_id,
      contract_end_date,
      contract_type,
      default_overtime_compensation_variant,
      employee_class,
      employment_type,
      end_date,
      holiday_calendar_code,
      job_code,
      custom_string2,
      custom_string11,
      custom_date4,
      pay_scale_area,
      pay_scale_group,
      pay_scale_level,
      pay_scale_type,
      custom_string10,
      probationary_period,
      probation_period_end_date,
      custom_string4,
      time_type_profile_code,
      time_recording_admissibility_code,
      time_recording_profile_code,
      time_recording_variant,
      timezone,
      workschedule_code,
      working_days_per_week,
      status,
    } = req.body;

    // Required fields check
    if (!employee_id_external || !start_date || !position_id || !status) {
      const errorMessage ="employee_id_external || !start_date|| !position_id || !status are required";
      return sendErrorResponse(res, errorMessage, errorMessage);
    }


    
    // duplicate record check employee-id-external
    const existing = await performQuery(
      `SELECT * FROM ${tables.emp_employee_details} WHERE employee_id_external = ?`,
      [employee_id_external]
    );
    if (existing.length > 0) {
      const errorMessage = "Employee details with the same employee_id_external already exists";
      return sendErrorResponse(res, errorMessage, errorMessage);
    }

    //duplicate record check position_id
    const existingPosition = await performQuery(
      `SELECT * FROM ${tables.emp_employee_details} WHERE position_id = ?`,
      [position_id]
    );
    if (existingPosition.length > 0) {
      const errorMessage = "Employee details with the same position_id already exists";
      return sendErrorResponse(res, errorMessage, errorMessage);
    }

    //duplicate record check manager_id
    const existingManager = await performQuery(
      `SELECT * FROM ${tables.emp_employee_details} WHERE manager_id = ?`,
      [manager_id]
    );
    if (existingManager.length > 0) {
      const errorMessage = "Employee details with the same manager_id already exists";
      return sendErrorResponse(res, errorMessage, errorMessage);
    }

   // Get system time
    const systemTime = await getSystemTime();
    const currentTime = moment(systemTime).format("YYYY-MM-DD HH:mm:ss");

    // Insert query
    await performQuery(`INSERT INTO ${tables.emp_employee_details} SET ?`, {
      employee_id_external,
      start_date,
      seq_no,
      event_reason,
      position_id,
      manager_id,
      custom_string_3,
      time_event_type_group_id,
      contract_end_date,
      contract_type,
      default_overtime_compensation_variant,
      employee_class,
      employment_type,
      end_date,
      holiday_calendar_code,
      job_code,
      custom_string2,
      custom_string11,
      custom_date4,
      pay_scale_area,
      pay_scale_group,
      pay_scale_level,
      pay_scale_type,
      custom_string10,
      probationary_period,
      probation_period_end_date,
      custom_string4,
      time_type_profile_code,
      time_recording_admissibility_code,
      time_recording_profile_code,
      time_recording_variant,
      timezone,
      workschedule_code,
      working_days_per_week,
      status,
      created_at: currentTime,
      created_by: req?.user?.id,
      updated_at: currentTime,
      updated_by: req?.user?.id,
    });

    return sendResponse(res, {}, "Employee Details created successfully", 200);

  } catch (error) {
    return sendErrorResponse(res, error, "Error while fetching Employye Details records");
  }
};

// Read Employee-Details
module.exports.getEmployeeDetails = async (req, res) => {
  try {
    const { id, employee_id_external, position_id, manager_id } = req.query;

    let query = `
      SELECT 
        empdetail.*,
        employee.employee_id_external AS employee_id_external,
        person.display_name AS employee_name,
        manager.employee_id_external AS manager_employee_id_external,
        manager_person.display_name AS manager_name,
        position.id AS position_id,
        position.external_name_US AS position_external_name_US
      FROM ${tables.emp_employee_details} AS empdetail
      LEFT JOIN ${tables.emp_employee} AS employee ON empdetail.employee_id_external = employee.employee_id_external
      AND employee.is_deleted = 2
      LEFT JOIN ${tables.per_person} AS person ON employee.person_id_external = person.person_id_external
      AND person.is_deleted = 2
      LEFT JOIN ${tables.emp_employee} AS manager ON empdetail.manager_id = manager.employee_id_external
      AND manager.is_deleted = 2
      LEFT JOIN ${tables.per_person} AS manager_person ON manager.person_id_external = manager_person.person_id_external
      AND manager_person.is_deleted = 2
      LEFT JOIN ${tables.org_position} AS position ON empdetail.position_id = position.id
      AND position.is_deleted = 2
      WHERE empdetail.is_deleted = 2
    `;

    if (id) query += ` AND empdetail.id = ${id}`;
    if (employee_id_external) query += ` AND empdetail.employee_id_external = '${employee_id_external}'`;
    if (position_id) query += ` AND empdetail.position_id = '${position_id}'`;
    if (manager_id) query += ` AND empdetail.manager_id = '${manager_id}'`;

    query += ` ORDER BY empdetail.id DESC`;

    const employeedetail = await performQuery(query);
    return sendResponse(res, employeedetail, "Employee Detail fetched successfully", 200);

  } catch (error) {
    console.error("Error while fetching Employee Detail:", error);
    return sendErrorResponse(res, error, "Error while fetching Employee Detail");
  }
};

// Update Employee-Details
module.exports.updateEmployeeDetails = async (req, res) => {
  try{
    const { 
      id,
      start_date,
      seq_no,
      event_reason,
      position_id,
      manager_id,
      custom_string_3,
      time_event_type_group_id,
      contract_end_date,
      contract_type,
      default_overtime_compensation_variant,
      employee_class,
      employment_type,
      end_date,
      holiday_calendar_code,
      job_code,
      custom_string2,
      custom_string11,
      custom_date4,
      pay_scale_area,
      pay_scale_group,
      pay_scale_level,
      pay_scale_type,
      custom_string10,
      probationary_period,
      probation_period_end_date,
      custom_string4,
      time_type_profile_code,
      time_recording_admissibility_code,
      time_recording_profile_code,
      time_recording_variant,
      timezone,
      workschedule_code,
      working_days_per_week,
      status,
    } = req.body;

    // Required fields check
    if (!id || !start_date|| !position_id || !status) {
      const errorMessage = "id || !start_date|| !position_id || !status are required";
      return sendErrorResponse(res, errorMessage, errorMessage);
    }

    // Check Record Exists
    const existing = await performQuery(
      `SELECT * FROM ${tables.emp_employee_details} WHERE id = ? AND is_deleted = 2`,
      [id]
    );

    if (!existing || existing.length === 0) {
      const errorMessage = "Employee Detail not found";
      return sendErrorResponse(res, errorMessage, errorMessage);
    }

    const oldRecord = existing[0];

    // System Time
    const systemTime = await getSystemTime();
    const currentTime = moment(systemTime).format("YYYY-MM-DD HH:mm:ss");

    // Prepare update object
    const updatedData = {
      start_date: start_date || oldRecord.start_date,
      seq_no: seq_no || oldRecord.seq_no,
      event_reason: event_reason || oldRecord.event_reason,
      position_id: position_id || oldRecord.position_id,
      manager_id: manager_id || oldRecord.manager_id,
      custom_string_3: custom_string_3 || oldRecord.custom_string_3,
      time_event_type_group_id: time_event_type_group_id || oldRecord.time_event_type_group_id,
      contract_end_date: contract_end_date || oldRecord.contract_end_date,
      contract_type: contract_type || oldRecord.contract_type,
      default_overtime_compensation_variant: default_overtime_compensation_variant || oldRecord.default_overtime_compensation_variant,
      employee_class: employee_class || oldRecord.employee_class,
      employment_type: employment_type || oldRecord.employment_type,
      end_date: end_date || oldRecord.end_date,
      holiday_calendar_code: holiday_calendar_code || oldRecord.holiday_calendar_code,
      job_code: job_code || oldRecord.job_code,
      custom_string2: custom_string2 || oldRecord.custom_string2,
      custom_string11: custom_string11 || oldRecord.custom_string11,
      custom_date4: custom_date4 || oldRecord.custom_date4,
      pay_scale_area: pay_scale_area || oldRecord.pay_scale_area,
      pay_scale_group: pay_scale_group || oldRecord.pay_scale_group,
      pay_scale_level: pay_scale_level || oldRecord.pay_scale_level,
      pay_scale_type: pay_scale_type || oldRecord.pay_scale_type,
      custom_string10: custom_string10 || oldRecord.custom_string10,
      probationary_period: probationary_period || oldRecord.probationary_period,
      probation_period_end_date: probation_period_end_date || oldRecord.probation_period_end_date,
      custom_string4: custom_string4 || oldRecord.custom_string4,
      time_type_profile_code: time_type_profile_code || oldRecord.time_type_profile_code,
      time_recording_admissibility_code: time_recording_admissibility_code || oldRecord.time_recording_admissibility_code,
      time_recording_profile_code: time_recording_profile_code || oldRecord.time_recording_profile_code,
      time_recording_variant: time_recording_variant || oldRecord.time_recording_variant,
      timezone: timezone || oldRecord.timezone,
      workschedule_code: workschedule_code || oldRecord.workschedule_code,
      working_days_per_week: working_days_per_week || oldRecord.working_days_per_week,
      status: status || oldRecord.status,
      updated_at: currentTime,
      updated_by: req?.user?.id || null,
    };

    // Update query
    await performQuery(`UPDATE ${tables.emp_employee_details} SET ? WHERE id = ?`, [
      updatedData,
      id,
    ]);

    return sendResponse(res, {}, "Employee Detail updated successfully", 200);
  } catch (error) {
    console.error("Error While Updating Employee Detail: ", error);
    return sendErrorResponse(res, error, "Error while updating Employee Detail");
  }

};

// // Delete Employee-Details
// module.exports.deleteEmployeeDetails = async (req, res) => {};



