const bcrypt = require("bcryptjs");

//==> Define a global function for sending a response to the user
function sendResponse(res, data, message, status = 200) {
  const response = res.status(status).json({
    message: message,
    data: data,
    success: true,
  });
  return response;
}

//==> Define a global function for sending an error response to the user
function sendErrorResponse(res, error, message, status = 500) {
  return res.status(status).json({
    message: message,
    error: error,
    success: false,
  });
}

async function generatePasswordResetToken() {
  //==> Generate a random string of characters
  const randomString = Math.random().toString(36).substring(2, 15);

  //==> Hash the random string with bcrypt
  const hashedRandomString = await bcrypt.hash(randomString, 10);

  //==> Return the hashed random string as the password reset token
  return hashedRandomString;
}

//==> Handle the error messages
async function handleError(error) {
  switch (error.message) {
    case "Email and password are required":
      // Send a response to the user indicating that the email and password are required
      break;
    case "Email address is already in use":
      // Send a response to the user indicating that the email address is already in use
      break;
    case "Invalid OTP":
      // Send a response to the user indicating that the OTP is invalid
      break;
    case "User does not exist":
      // Send a response to the user indicating that the user does not exist
      break;
    default:
      // Handle the error in some other way
      break;
  }
}


// ==> Define a global function for sending an empty response to the user
function sendEmptyResponse(res, error, message, status = 400) {
  return res.status(status).json({
    message: message,
    error: error,
    success: false,
  });
}

// ==> Define a global function for sending a response when data already exists
function dataAlreadyExist(res, error, message, status = 409) {
  return res.status(status).json({
    message: message,
    error: error,
    success: false,
  });
}


module.exports = {
  sendErrorResponse,
  sendResponse,
  generatePasswordResetToken,
  handleError,
  dataAlreadyExist,
  sendEmptyResponse
};
