const { getSystemTime } = require("../functions/getTimezone");
const { logger } = require("../helper/logger.helper");
const moment = require("moment-timezone");
const { performQuery } = require("../utils/db");
const { tables } = require("../utils/tables");


module.exports.createTimeEventCronJob = async () => {
    try {
        const systemtime = await getSystemTime();
        // const currenttime = moment(systemtime).subtract(15, 'minutes').format("YYYY-MM-DD HH:mm:ss")
        const currenttime = moment(systemtime).subtract(0, 'days').format("YYYY-MM-DD HH:mm:ss")
        const date = moment(currenttime).format("YYYY-MM-DD");
        const dayofWeek = moment(currenttime).weekday(); // 0 (Sunday) to 6 (Saturday)

        let attendanceDataQuery = `
            SELECT 
                ad.id, ad.unique_value, au.employee_id_external, 
                ad.date, ad.clock_in, ad.clock_out, 
                te_ci.time_event_id_external AS clockin_event, 
                te_co.time_event_id_external AS clockout_event,
                ed.workschedule_code, ed.time_profile_code, tp.main_attendance_time_type, dm.planned_hours,
                mit.start_time AS min_in_time, mot.end_time AS max_out_time,
                ts.time_sheet_id_external, tsd.id AS time_sheet_detail_id, tsd.day, tsd.planned_time, tsd.recorded_time, tsd.recordings,
                ts.recorded_working_time
            FROM ${tables.attendance_user} au
            LEFT JOIN ${tables.attendance_data} ad ON ad.employee_id = au.id and ad.date = '${date}' 
            LEFT JOIN ${tables.time_event} te_ci ON te_ci.attendance_data_unique_value = ad.unique_value AND te_ci.time_event_type = 103 AND te_ci.is_active = 1
            LEFT JOIN ${tables.time_event} te_co ON te_co.attendance_data_unique_value = ad.unique_value AND te_co.time_event_type = 104 AND te_co.is_active = 1
            LEFT JOIN ${tables.emp_employee_details} ed ON ed.employee_id_external = au.employee_id_external AND ed.is_deleted = 2
            LEFT JOIN ${tables.work_schedule} ws ON ws.schedule_id_external = ed.workschedule_code AND ws.is_active = 1
            LEFT JOIN ${tables.time_profile} tp ON tp.time_profile_id_external = ed.time_profile_code AND tp.is_active = 1
            LEFT JOIN ${tables.work_schedule_details} wsd ON wsd.schedule_id_external = ws.schedule_id_external AND wsd.day = ${dayofWeek} AND wsd.is_active = 1
            LEFT JOIN ${tables.day_model} dm ON dm.day_model_id_external = wsd.day_model_id_external AND dm.is_active = 1
            LEFT JOIN ${tables.time_sheet} ts ON ts.employee_id_external = au.employee_id_external AND ts.is_active = 1
            LEFT JOIN ${tables.time_sheet_detail} tsd ON tsd.date = '${date}' AND tsd.time_sheet_id_external = ts.time_sheet_id_external AND tsd.is_active = 1
            LEFT JOIN (
                SELECT day_model_id_external, MIN(start_time) AS start_time
                FROM ${tables.day_model_segments}
                WHERE is_active = 1
                GROUP BY day_model_id_external
            ) mit ON mit.day_model_id_external = dm.day_model_id_external
            LEFT JOIN (
                SELECT day_model_id_external, MAX(end_time) AS end_time
                FROM ${tables.day_model_segments}
                WHERE is_active = 1
                GROUP BY day_model_id_external
            ) mot ON mot.day_model_id_external = dm.day_model_id_external
            where au.employee_id_external IS NOT NULL
        `

        // get Attendance Data for current Data and where employee id external is not null
        logger.info("Executing Attendance Data Query for Time Event Cron Job: ", attendanceDataQuery);
        
        let attendanceData = await performQuery(attendanceDataQuery);     
        attendanceData = attendanceData.filter(ad => ad.id !== null);
        logger.info("Attendance Data fetched for Time Event Cron Job: ", attendanceData);
        
        

        if(attendanceData.length === 0) {
            console.log("No attendance data found for date: ", date);
            return;
        }
        else{
            let clockInEventsInsertQuery = `
                INSERT INTO ${tables.time_event} (
                    time_event_id_external, date, attendance_data_unique_value, 
                    employee_id_external, time_value, time_event_type, approval_status, 
                    approval_timestamp, created_at, updated_at
                )  Values `;
            let clockOutEventsInsertQuery = `
                INSERT INTO ${tables.time_event} (
                    time_event_id_external, date, attendance_data_unique_value, 
                    employee_id_external, time_value, time_event_type, approval_status, 
                    approval_timestamp, created_at, updated_at
                )  Values `;
            let timeTypeRequestsInsertQuery = `
                INSERT INTO ${tables.time_type_request} (
                    time_type_request_id_external, employee_id_external, time_type_id_external, 
                    start_date, end_date, duration,  
                    approval_status, approval_remarks
                )  Values `;
            let timeTypeRequestsUpdateQuery = `
                UPDATE oee2024_trisync_time_tracking.time_type_request t
                JOIN ( `;
            let timeSheetUpdateQuery = `
                UPDATE ${tables.time_sheet} ts
                JOIN ( `;
            let timeSheetDetailUpdateQuery = `
                UPDATE ${tables.time_sheet_detail} tsd
                JOIN ( `;

            attendanceData.map(ad => {
                if (ad.clock_in !== 'N/A' && !ad.clockin_event) {
                    const time_event_id_external = `${ad.employee_id_external}-${date}-IN`
                    clockInEventsInsertQuery += `(
                        '${time_event_id_external}', '${date}', '${ad.unique_value}', 
                        '${ad.employee_id_external}', '${ad.clock_in}', 103, 1, 
                        '${currenttime}', '${currenttime}', '${currenttime}'),`
                    
                    if(ad.workschedule_code && ad.time_profile_code) {
                        const time_type_request_id_external = `${ad.employee_id_external}_${ad.main_attendance_time_type}_${moment(ad.clock_in).format("YYYYMMDD")}`
                        timeTypeRequestsInsertQuery += `(
                            '${time_type_request_id_external}', '${ad.employee_id_external}', '${ad.main_attendance_time_type}', 
                            '${ad.clock_in}', 
                            '${moment(ad.clock_in).add(ad.planned_hours,'hours').format("YYYY-MM-DD HH:mm:ss")}', 
                            '${parseFloat(ad.planned_hours)*60}', 1, 'Auto created by system'
                        ),`
                    }
                }
                if (ad.clock_out !== 'N/A' && !ad.clockout_event) {
                    const time_event_id_external = `${ad.employee_id_external}-${date}-OUT`
                    const duration = moment(ad.clock_out).diff(moment(ad.clock_in), 'minutes') // calculate duration in minutes between clock_in and clock_out
                    const daily_planned_hours = ad.planned_hours ? parseFloat(ad.planned_hours) * 60 : 0;
                    const recorded_time = duration;
                    const early_leave = duration < daily_planned_hours;                    

                    clockOutEventsInsertQuery += `(
                        '${time_event_id_external}', '${date}', '${ad.unique_value}', 
                        '${ad.employee_id_external}', '${ad.clock_out}', 104, 1, 
                        '${currenttime}', '${currenttime}', '${currenttime}'),`
                    
                    if(ad.workschedule_code && ad.time_profile_code) {
                        const time_type_request_id_external = `${ad.employee_id_external}_${ad.main_attendance_time_type}_${moment(ad.clock_in).format("YYYYMMDD")}`
                        timeTypeRequestsUpdateQuery += `
                            ${timeTypeRequestsUpdateQuery.length > 100 ? 'UNION ALL' : ''}
                            SELECT 
                                '${time_type_request_id_external}' ${timeTypeRequestsUpdateQuery.length <= 100 ? 'AS req_id,' : ','}
                                '${moment(ad.clock_out).format("YYYY-MM-DD HH:mm:ss")}' ${timeTypeRequestsUpdateQuery.length <= 100 ? 'AS end_dt,' : ','} 
                                ${duration} ${timeTypeRequestsUpdateQuery.length <= 100 ? 'AS duration' : ''}
                        `
                    }
                    if(ad.time_sheet_id_external) {
                        timeSheetUpdateQuery += `
                            ${timeSheetUpdateQuery.length > 100 ? 'UNION ALL' : ''}
                            SELECT 
                                '${ad.time_sheet_id_external}' ${timeSheetUpdateQuery.length <= 100 ? 'AS req_id,' : ','}
                                '${Number(ad.recorded_working_time) + recorded_time}' ${timeSheetUpdateQuery.length <= 100 ? 'AS recorded_WT' : ''} 
                        `
                    }
                    if(ad.time_sheet_detail_id) {
                        timeSheetDetailUpdateQuery += `
                            ${timeSheetDetailUpdateQuery.length > 100 ? 'UNION ALL' : ''}
                            SELECT 
                                '${ad.time_sheet_detail_id}' ${timeSheetDetailUpdateQuery.length <= 100 ? 'AS req_id,' : ','}
                                '${Number(ad.recorded_time) + recorded_time}' ${timeSheetDetailUpdateQuery.length <= 100 ? 'AS recorded_WT,' : ','} 
                                '${early_leave ? "Early Leave" : ""}' ${timeSheetDetailUpdateQuery.length <= 100 ? 'AS note' : ''} 
                        `
                    }

                }
            });
            
            timeTypeRequestsUpdateQuery += `
                ) src ON src.req_id = t.time_type_request_id_external SET t.end_date = src.end_dt, t.duration = src.duration;
            `
            timeSheetUpdateQuery += `
                ) src ON src.req_id = ts.time_sheet_id_external SET ts.recorded_working_time = src.recorded_WT;
            `
            timeSheetDetailUpdateQuery += `
                ) src ON src.req_id = tsd.id SET tsd.recorded_time = src.recorded_WT, tsd.notes = src.note;
            `

            if(clockInEventsInsertQuery.slice(0, -1).length > 340) {
                logger.info("Inserting Clock In Events with Query: ", clockInEventsInsertQuery.slice(0, -1) + ";");
                const insertClockInEvents = await performQuery(clockInEventsInsertQuery.slice(0, -1) + ";");
            }
            if(clockOutEventsInsertQuery.slice(0, -1).length > 340) {
                logger.info("Inserting Clock Out Events with Query: ", clockOutEventsInsertQuery.slice(0, -1) + ";");
                const insertClockOutEvents = await performQuery(clockOutEventsInsertQuery.slice(0, -1) + ";");
            }
            if(timeTypeRequestsInsertQuery.slice(0, -1).length > 320) {
                logger.info("Inserting Time Type Requests with Query: ", timeTypeRequestsInsertQuery.slice(0, -1) + ";");
                const insertTimeTypeRequests = await performQuery(timeTypeRequestsInsertQuery.slice(0, -1) + ";");
            }
            if(timeTypeRequestsUpdateQuery.length > 240) {
                logger.info("Updating Time Type Requests with Query: ", timeTypeRequestsUpdateQuery + ";");
                const insertTimeTypeRequests = await performQuery(timeTypeRequestsUpdateQuery + ";");
            }
            if(timeSheetUpdateQuery.length > 230) {
                logger.info("Updating Time Sheet with Query: ", timeSheetUpdateQuery + ";")
                const insertTimeSheet = await performQuery(timeSheetUpdateQuery + ";");
            }
            if(timeSheetDetailUpdateQuery.length > 230) {
                logger.info("Updating Time Sheet Detail with Query: ", timeSheetDetailUpdateQuery + ";");
                const insertTimeSheetDetail = await performQuery(timeSheetDetailUpdateQuery + ";");
            }
        }
    } catch (error) {
        console.log("Error in Create Time Event Cron Job: ", error);
        logger.error("Error in Create Time Event Cron Job: ", error);
    }
}


