const jwt = require("jsonwebtoken");
const { tables } = require("../utils/tables");
const { performQuery } = require("../utils/db");
const { JWT_SECRET } = require("../config");
const { sendErrorResponse } = require("../utils");
const { logger, errorHandler } = require("../helper/logger.helper");
const { getTimezone, getSystemTime } = require("../functions/getTimezone");

// Define the middleware
module.exports.authMiddleware = async (req, res, next) => {
  try {
    console.log("------------Request Query--------", req.query);
    console.log("------------Request Body--------", req.body);
    console.log("------------Request Path--------", req.path);
    const { method, url, headers, body, query, path } = req;
    const { token, authorization, ...rest } = headers;

    let getToken = token?.split(" ")?.[1] || authorization?.split(" ")?.[1] || '';
    if (getToken.startsWith('"') && getToken.endsWith('"')) {
      getToken = getToken.slice(1, -1);
    }

    if (!getToken) {
      return sendErrorResponse(res, {}, "User Not Authenticated", 401);
    }

    // ✅ Verify token synchronously (throws if expired/invalid)
    let userData;
    try {
      userData = jwt.verify(getToken, JWT_SECRET);
    } catch (err) {
      console.log("JWT verification failed:", err.message);
      return sendErrorResponse(res, err, "Token expired or invalid", 401);
    }

    const verifyUser = await performQuery(`
      SELECT p.display_name, emp.employee_id_external 
      FROM ${tables.per_person} p
      LEFT JOIN ${tables.emp_employee} emp ON emp.person_id_external = p.person_id_external AND emp.is_deleted = 2
      WHERE p.id = ? AND p.is_deleted = 2`, 
      [userData.id]
    );
    userData.employee_id_external = verifyUser[0]?.employee_id_external;
    req.user = userData; // ✅ Now we have valid decoded token
    
    // Log request with user info
    logger.info(`Request: ${method} ${url}`, {
      headers: rest,
      path,
      body,
      query,
      user: {
        id: userData?.id,
        username: userData?.username,
        email: userData?.email,
      },
    });

    // // Fetch user from DB
    // const user = await performQuery(`SELECT * FROM ${tables.employees} WHERE id = ?`, [userData.id]);
    // if (!user?.length) {
    //   return sendErrorResponse(res, {}, "Invalid token user", 401);
    // }

    // // Check if token is older than 1h
    // const issueDate = userData.iat * 1000;
    // const nowDate = Date.now();
    // if (nowDate - issueDate > 3600000) {
    //   await performQuery(`UPDATE ${tables.employees} SET token = NULL WHERE id = ?`, [userData.id]);
    //   return sendErrorResponse(res, {}, "Token expired, please login again", 401);
    // }

    // // Refresh token
    // const systemTime = await getSystemTime();
    // const payload = {
    //   id: user[0]?.id,
    //   name: user[0]?.full_name,
    //   email: user[0]?.email,
    //   role: user[0]?.role,
    //   iat: Math.floor(systemTime.valueOf() / 1000),
    // };
    // const newToken = jwt.sign(payload, JWT_SECRET, { expiresIn: "1h" });
    // await performQuery(`UPDATE ${tables.employees} SET token = ? WHERE id = ?`, [newToken, userData.id]);

    // res.set("new-token", newToken);

    next(); // ✅ Continue only after successful verification
  } catch (error) {
    console.log("Error in Auth Middleware:", error);
    return sendErrorResponse(res, error, "Invalid token", 401);
  }
};


// // Define the middleware
// module.exports.adminMiddleware = async (req, res, next) => {
//   try {
//     const { method, url, headers, body, query, path } = req;
//     const { token, authorization, ...rest } = headers;

//     let getToken = token?.split(" ")?.[1] || authorization?.split(" ")?.[1] || '';
//     if (getToken.startsWith('"') && getToken.endsWith('"')) {
//       getToken = getToken.slice(1, -1);
//     }

//     if (!getToken) {
//       return sendErrorResponse(res, {}, "User Not Authenticated", 401);
//     }

//     // ✅ Verify token synchronously (throws if expired/invalid)
//     let userData;
//     try {
//       userData = jwt.verify(getToken, JWT_SECRET);
//     } catch (err) {
//       console.log("JWT verification failed:", err.message);
//       return sendErrorResponse(res, err, "Token expired or invalid", 401);
//     }

//     req.user = userData; // ✅ Now we have valid decoded token
//     console.log("Decoded userData >>>>", userData);

//     // Log request with user info
//     logger.info(`Request: ${method} ${url}`, {
//       headers: rest,
//       path,
//       body,
//       query,
//       user: {
//         id: userData?.id,
//         username: userData?.username,
//         email: userData?.email,
//       },
//     });

//     // Fetch user from DB
//     const user = await performQuery(`SELECT * FROM ${tables.employees} WHERE id = ?`, [userData.id]);
//     if (!user?.length) {
//       return sendErrorResponse(res, {}, "Invalid token user", 401);
//     }

//     console.log("Fetched user from DB:", user);
    

//     // Check if user is admin
//     if (user[0]?.role > 1) {
//       return sendErrorResponse(res, {}, "Access denied", 403);
//     }

//     next(); // ✅ Continue only after successful verification
//   } catch (error) {
//     console.log("Error in Auth Middleware:", error);
//     return sendErrorResponse(res, error, "Invalid token", 401);
//   }
// };
// // Define the middleware
// module.exports.teamLeadMiddleware = async (req, res, next) => {
//   try {
//     const { method, url, headers, body, query, path } = req;
//     const { token, authorization, ...rest } = headers;

//     let getToken = token?.split(" ")?.[1] || authorization?.split(" ")?.[1] || '';
//     if (getToken.startsWith('"') && getToken.endsWith('"')) {
//       getToken = getToken.slice(1, -1);
//     }

//     if (!getToken) {
//       return sendErrorResponse(res, {}, "User Not Authenticated", 401);
//     }

//     // ✅ Verify token synchronously (throws if expired/invalid)
//     let userData;
//     try {
//       userData = jwt.verify(getToken, JWT_SECRET);
//     } catch (err) {
//       console.log("JWT verification failed:", err.message);
//       return sendErrorResponse(res, err, "Token expired or invalid", 401);
//     }

//     req.user = userData; // ✅ Now we have valid decoded token
//     console.log("Decoded userData >>>>", userData);

//     // Log request with user info
//     logger.info(`Request: ${method} ${url}`, {
//       headers: rest,
//       path,
//       body,
//       query,
//       user: {
//         id: userData?.id,
//         username: userData?.username,
//         email: userData?.email,
//       },
//     });

//     // Fetch user from DB
//     const user = await performQuery(`SELECT * FROM ${tables.employees} WHERE id = ?`, [userData.id]);
//     if (!user?.length) {
//       return sendErrorResponse(res, {}, "Invalid token user", 401);
//     }

//     console.log("Fetched user from DB:", user);
    

//     // Check if user is admin
//     if (user[0]?.role !== 2) {
//       return sendErrorResponse(res, {}, "Access denied", 403);
//     }

//     next(); // ✅ Continue only after successful verification
//   } catch (error) {
//     console.log("Error in Auth Middleware:", error);
//     return sendErrorResponse(res, error, "Invalid token", 401);
//   }
// };
